import misc.Debug;
import types.DataClass;
import types.Rahmen;

class SelectiveRepeat extends Protocol {

    // Variables
    
    int m_iLastAckSend;

	public SelectiveRepeat(Computer a)	{
		super(a);
		sendWindow = new DataClass(8,4);
		m_Buffer1.setMaxSize(sendWindow.maxWindowSize());
		receiveWindow = new DataClass(8,4);
		m_Buffer2.setMaxSize(receiveWindow.maxWindowSize());
		sendWindow.lowerBound(0);
		sendWindow.upperBound(0);
		receiveWindow.lowerBound(0);
		receiveWindow.upperBound(0);
		m_iTimeSteps=4;
        m_iLastAckSend=-1;
	}
	public void Work() {
	    switch (m_Event) {
		case 0: // Event frame send
		    // This Event happens, is Layer n+1 wants to send some data
		    // First check, if sending is allowed
		    if (sendWindow.windowSize()<sendWindow.maxWindowSize()) {
		        // first check, if sequence number belongs to a frame that must be retransmitted
		        Rahmen frame;
		        frame=m_Buffer1.getFrame(sendWindow.upperBound());
		        if (frame==null) {
		            // otherwise
		            // Create new frame with sequencenumber of upperbound
    		        frame = new Rahmen(sendWindow.upperBound(),-1,Rahmen.DATA,m_Computer.getData());
    		        // put it in the buffer
    		        m_Buffer1.addFrame(frame);
		        }
		        // Mark frame as undamaged
		        frame.repair();
		        // Put frame on the way
		        m_Computer.lowerLayerSend(frame);
		        // Start timer (in this case, one timer for each sequence number)
		        // The timer expires after m_iTimeSteps abstract timesteps
		        m_Computer.timer().insertTimer(sendWindow.upperBound(),m_iTimeSteps);
		        sendWindow.incUpperBound(1);
		    }
			break;
		case 1: // Event Accept one Frame
		    // This Event happens, if Layer n+1 is ready to accept and acknowledge
		    // a dataFrame waiting at Layer n
		    // First check, if any Frame is available
		    boolean bAccepted=false;
		    while (m_Buffer2.findFrame(receiveWindow.lowerBound())) {
		        // Take frame with seqNr of lowerBound remove it from Buffer2
		        Rahmen frame = m_Buffer2.getFrame(receiveWindow.lowerBound());
		        m_Buffer2.removeFrame(receiveWindow.lowerBound());
		        // Distinguish type of Frame
                m_Computer.writeData(frame.data());
                m_iLastAckSend = receiveWindow.lowerBound();
                receiveWindow.incLowerBound(1);
                bAccepted = true;
            }
            if (bAccepted)
                m_Computer.lowerLayerSend(new Rahmen(0,m_iLastAckSend,Rahmen.ACK));
			break;
	    case 2: // Event frame arriving from Lowerlayer
	        // This Event happens, if a Rahmen arrives from Layer n-1
            if (m_Frame.iKind()==Rahmen.DATA) {
                // A Data frame arrived
                // Determine valid data frames
                int iFirstAccepted = receiveWindow.lowerBound();
                int iLastAccepted = receiveWindow.add(receiveWindow.lowerBound(),receiveWindow.maxWindowSize());
                // Check if frame is already in the buffer
                if ((!m_Buffer2.findFrame(m_Frame.seqNr()))&&
                    (receiveWindow.isBetween(iFirstAccepted,iLastAccepted,m_Frame.seqNr()))) {
                    m_Buffer2.addFrame(m_Frame);
                    receiveWindow.incUpperBound(1);
    	        }
    	        else {
    	            // Out of sequence, purge Frame & resend Ack
                    m_Computer.lowerLayerSend(new Rahmen(0,m_iLastAckSend,Rahmen.ACK));
                }
    	    }
	        if (m_Frame.iKind()==Rahmen.ACK) {
	            // An Acknowledgement arrived, check if it is the right one
	            int iAck = m_Frame.seqNrAck();
	            while (m_Buffer1.removeFrame(iAck)) {
                    m_Computer.timer().removeTimer(iAck);
                    sendWindow.incLowerBound(1);
                    iAck = sendWindow.subtract(iAck,1);
                }
            }
            break;
		case 4: // Event Timeout
		    // Get the timed out Frame from the buffer
	        Rahmen frame=m_Buffer1.getFrame(m_iPar1);
	        // retransmit it
	        frame.repair();
	        m_Computer.lowerLayerSend(frame);
	        // start a new timer
	        m_Computer.timer().insertTimer(m_iPar1,m_iTimeSteps);
		    break;
		}
		if (sendWindow.windowSize()>sendWindow.maxWindowSize()) {
		    Debug.out("Fehler");
		}
	}
	public int anzBuffered() {
	    return(sendWindow.windowSize());
	}
}

